gpu=0
adpt_td_weight=0.001
adpt_steps=1000
adpt_lr=0.05
use_wandb=0
export WANDB_INIT_TIMEOUT="300"
cvar_alpha=0.7
adpt_td_type='qf'

for adpt_batch_demo in 16 32 64 128 256 
do
    record_label="adpt_batch_demo=${adpt_batch_demo}"

    for env in MO-Ant-v2 OfflineBallCircle-v0
    do
        if [ $env = 'MO-Ant-v2' ];  
        then  
            dataset_class='d4morl'
            dataset_type='amateur_uniform'
            seeds=(0 1 2)  
        else  
            dataset_class='safe'
            dataset_type='None'
            seeds=(0 1 2)
        fi

        for seed in ${seeds[*]}    
        do
            algo='Diffusion-QL'
            normalize_states=1
            nohup python train_eval.py \
                --record_label $record_label\
                --dataset_type $dataset_type\
                --test_only 1 \
                --env $env\
                --seed $seed \
                --dataset $dataset_class\
                --gpu $gpu \
                --use_wandb $use_wandb \
                --algo $algo\
                --normalize_states $normalize_states\
                --adpt_td_weight $adpt_td_weight\
                --adpt_lr $adpt_lr\
                --adpt_steps $adpt_steps\
                --adpt_batch_demo $adpt_batch_demo\
                --adpt_td_type $adpt_td_type\
                --cvar_alpha $cvar_alpha\
            > logs/${env}_${dataset_type}_${seed}_${record_label}_test.txt &

            seed=$(($seed+1))

            algo='PEDA'
            normalize_states=1
            nohup python train_eval.py \
                --record_label $record_label\
                --test_only 1 \
                --env $env\
                --seed $seed \
                --dataset $dataset_class\
                --gpu $gpu \
                --use_wandb $use_wandb \
                --algo $algo\
                --normalize_states $normalize_states\
                --adpt_td_weight $adpt_td_weight\
                --adpt_lr $adpt_lr\
                --adpt_steps $adpt_steps\
                --adpt_batch_demo $adpt_batch_demo\
                --adpt_td_type $adpt_td_type\
                --cvar_alpha $cvar_alpha\
            > logs/${env}_${seed}_${record_label}_test.txt &
        done
        
    done
    gpu=$(($gpu+1))
done

adpt_batch_demo=128
for cvar_alpha in 0.2 0.4 0.6 0.8 1.0
do
    record_label="cvar_alpha=${cvar_alpha}"

    for env in OfflineAntCircle-v0  OfflineBallCircle-v0
    do 
        dataset_class='safe'
        seeds=(0 1 2)

        for seed in ${seeds[*]}   
        do
            algo='Diffusion-QL'
            normalize_states=1
            nohup python train_eval.py \
                --record_label $record_label\
                --test_only 1 \
                --env $env\
                --seed $seed \
                --dataset $dataset_class\
                --gpu $gpu \
                --use_wandb $use_wandb \
                --algo $algo\
                --normalize_states $normalize_states\
                --adpt_td_weight $adpt_td_weight\
                --adpt_lr $adpt_lr\
                --adpt_steps $adpt_steps\
                --adpt_batch_demo $adpt_batch_demo\
                --adpt_td_type $adpt_td_type\
                --cvar_alpha $cvar_alpha\
            > logs/${env}_${seed}_${record_label}_test.txt &

            seed=$(($seed+1))

            algo='PEDA'
            normalize_states=1
            nohup python train_eval.py \
                --record_label $record_label\
                --test_only 1 \
                --env $env\
                --seed $seed \
                --dataset $dataset_class\
                --gpu $gpu \
                --use_wandb $use_wandb \
                --algo $algo\
                --normalize_states $normalize_states\
                --adpt_td_weight $adpt_td_weight\
                --adpt_lr $adpt_lr\
                --adpt_steps $adpt_steps\
                --adpt_batch_demo $adpt_batch_demo\
                --adpt_td_type $adpt_td_type\
                --cvar_alpha $cvar_alpha\
            > logs/${env}_${seed}_${record_label}_test.txt &
        done
    done
    gpu=$(($gpu+1))
done